<?php
session_start();
require 'db.php'; // Datubāzes savienojums

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Iegūstam lietotāja kalendārus
$stmt = $pdo->prepare("SELECT * FROM calendars WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$calendars = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
<?php include 'header.php'; ?>

<h1>Mani kalendāri</h1>
<a href="create_calendar.php">Izveidot jaunu kalendāru</a>

<div class="calendar-list">
    <?php foreach ($calendars as $calendar): ?>
        <div class="calendar" style="border-left: 5px solid <?php echo htmlspecialchars($calendar['color']); ?>;">
            <h2><?php echo htmlspecialchars($calendar['name']); ?></h2>
            <a href="add_task.php?calendar_id=<?php echo $calendar['id']; ?>">Pievienot uzdevumu</a>
            <a href="share_calendar.php?calendar_id=<?php echo $calendar['id']; ?>">Koplietot kalendāru</a>

            <!-- Uzdevumu saraksts -->
            <div class="tasks-list">
                <?php
                $stmt = $pdo->prepare("SELECT * FROM tasks WHERE calendar_id = ?");
                $stmt->execute([$calendar['id']]);
                $tasks = $stmt->fetchAll();
                foreach ($tasks as $task): ?>
                    <div class="task">
                        <h4><?php echo htmlspecialchars($task['title']); ?></h4>
                        <p><?php echo htmlspecialchars($task['description']); ?></p>
                        <p>Sākums: <?php echo htmlspecialchars($task['start_time']); ?></p>
                        <p>Beigas: <?php echo htmlspecialchars($task['end_time']); ?></p>
                        <a href="edit_task.php?task_id=<?php echo $task['id']; ?>">Rediģēt</a> |
                        <a href="delete_task.php?task_id=<?php echo $task['id']; ?>" onclick="return confirm('Vai tiešām vēlaties dzēst šo uzdevumu?');">Dzēst</a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php include 'footer.php'; ?>
</body>
</html>
